/*
  Simple analog input organ
 */

int ledPin1;
int ledPin2;
int ledPin3;
int ledPin4;
int analogInputPin;
int speakerPin;
int count;
// We are going to do more advanced maths in this version which involves
// non-integer numbers. We can use "float" variables to store
// decimal numbers.
float inputValue;
float length;
float frequency;


void setup() { 
 // We are going to use Pin 5 for the LED output as this pin supports PWM and
 // doesn't have interference due to the use of the "tone" function. 
  ledPin1=2; 
  ledPin2=3;
  ledPin3=4;
  ledPin4=5; 
  analogInputPin=0;
  speakerPin=7;
  
  // Count is a variable we use to count the number of pulses in our wave
  // set it to zero to start
  count=0;
  
  // Analog pins are always an input so we don't need to assign those
  // Still assign the speaker and ledPin as an output.
  pinMode(ledPin1, OUTPUT);
  pinMode(ledPin2, OUTPUT);
  pinMode(ledPin3, OUTPUT);
  pinMode(ledPin4, OUTPUT);
  pinMode(speakerPin, OUTPUT);
}

void loop() {
  // Find out the value of the analog input
  // analogRead returns a value of between 0 and 1023
  // where 0 is 0V and 1023 is 5V.
  // In this version we assign it to a float variable to make
  // the maths work later.
  inputValue=analogRead(analogInputPin);
  // Only want to play a note if the wire probes are on the track, so check
  // for voltages that aren't close to 0V before playing a tone
  // else silence the tone
  if (inputValue>10) {
    
    // If the value is too high it means the probes are almost touching
    // We don't want very low notes that just sound like a series of clicks
    // so limit the maximum value
    if (inputValue>850)
      inputValue=850;
      
    // Calculate the "length" of the track. This isn't in any units
    // just a relative measure  
    length=(1023-inputValue)/inputValue;
    // This calculates the frequency of the organ based on the length. There are two functions 
    // the pow() function calculates a power of 2 which is similar to the notes on a piano.
    // The map() function then maps numbers in one range to another range.
    frequency=map(pow(2,length),1.14,512,27.5,4186);
    
    // Delay for a lengh of time based on the frequency. We use two delay routines
    // to get more accuracy at high frequencies and to take account of the limit of maximum delay
    // in delayMicroseconds()
    if (frequency>100)
      delayMicroseconds(1000000/(2*frequency));
    else
      delay(1000/(2*frequency));
    
    // After the delay, swap the value of the speakerPin output
    // Note you can read the value of a pin even if it is an output!
    if (digitalRead(speakerPin)==LOW)
      digitalWrite(speakerPin,HIGH);
    else
      digitalWrite(speakerPin,LOW);
    
    // Count the number of changes (up to 64). If the count goes over 64 go back to 0
    count=count+1;
    if (count>64)
      count=0;
      
    // Light one of four LEDs based on the value of the count.  
    if (count<16)
      digitalWrite(ledPin1,HIGH);
    else
      digitalWrite(ledPin1,LOW);
    if (count>=16 and count<32)
      digitalWrite(ledPin2,HIGH);
    else
      digitalWrite(ledPin2,LOW);
    if (count>=32 and count<48)
      digitalWrite(ledPin3,HIGH);
    else
      digitalWrite(ledPin3,LOW);
    if (count>=48)
      digitalWrite(ledPin4,HIGH);
    else
      digitalWrite(ledPin4,LOW);
  }
    
}
