#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <util/delay.h>
#include <avr/sleep.h>

#ifndef ABS
#define ABS(a) ((a) >= 0 ? (a) : -(a))
#endif


double notes[9] = {440.0 , 329.6, 261.6, 196.0, 146.8, 110.0, 587.3, 82.4, 220.0 }; // Note frequenices Hz

int onperiod[5] = {6,10,14,18,22}; // Beep on times (cs)
int offperiod[5] = {3, 5, 7, 9, 11}; // Beep off times (cs)

int8_t lastnote=0;
int8_t targetnote=1;


void setftone(double f,uint8_t d) {
	int16_t	t;
	if (f==0)
	//	TCCR1A=0;
		TCCR1A=_BV(WGM11);
	else {
	//	t=F_CPU/(8.0*2.0*f);
	//	OCR1AH=t>>8;
	//	OCR1AL=t&0xff;
//		TCCR1A=_BV(COM1A0);
		t=F_CPU/(8.0*f);
		ICR1H=t>>8;
		ICR1L=t&0xff;
		t=t>>d;
		OCR1AH=t>>8;
		OCR1AL=t&0xff;
		TCCR1A=_BV(COM1A1)|_BV(WGM11);
	}
}

void setf(double f) {
	setftone(f,1);
}

void ioinit(void) {
	DDRB=_BV(PB1);
	PORTB=_BV(PB3); // activate pull up on PB3;
//	TCCR1A=_BV(COM1A0);
//	TCCR1B=_BV(WGM12)|_BV(CS11); // Set CTC mode and clock divide by 8
	TCCR1A=_BV(WGM11);
	TCCR1B=_BV(WGM13)|_BV(WGM12)|_BV(CS11);
	PORTD=0x7c;

}

void delaycentiseconds(int n){
	uint16_t i;
	for(i=0;i<n;i++)
		_delay_ms(10);
}

void delaydecseconds(int n){
	uint16_t i;
	for(i=0;i<10*n;i++)
		_delay_ms(10);
}

uint16_t getnoteraw(void) {
	uint16_t i;
	i=0x3f;
	if (PIND & _BV(5))
		i&= ~_BV(0);
	if (PIND & _BV(6))
		i&= ~_BV(1);
	if (PIND & _BV(7))
		i&= ~_BV(2);
	if (PINB & _BV(0))
		i&= ~_BV(3);
	if (PIND & _BV(4))
		i&= ~_BV(4);
	if (PINB & _BV(2))
		i&= ~_BV(5);
		
	return i;

}

uint16_t getscaleraw(void) {
	uint16_t i;
	i=0xfff;
	if (PIND & _BV(3))
		i&= ~_BV(10);
	if (PINC & _BV(2))
		i&= ~_BV(9);
	if (PINC & _BV(3))
		i&= ~_BV(8);
	if (PINC & _BV(5))
		i&= ~_BV(7);
	if (PINC & _BV(4))
		i&= ~_BV(6);
		
	if (PINB & _BV(5))
		i&= ~_BV(5);
		
	if (PINC & _BV(1))
		i&= ~_BV(4);
	if (PINC & _BV(0))
		i&= ~_BV(3);
	if (PIND & _BV(2))
		i&= ~_BV(2);
	if (PIND & _BV(1))
		i&= ~_BV(1);
	if (PIND & _BV(0))
		i&= ~_BV(0);
	
	
	if (PINB & _BV(4))
		i&= ~_BV(11);
	

	return i;
}

void getscale(uint16_t *s,uint16_t *n) {
	uint16_t i;
	uint16_t j;
	i=getscaleraw();
	j=getnoteraw();
	_delay_ms(1);
	*s= i | getscaleraw();
	*n= j | getnoteraw();
}

int8_t getnote(uint16_t s) {
	int8_t i;
	if (s==0)
		return 0;
	else
		for(i=0;i<6;i++)
			if (s & _BV(i))
				return i+1;
	return 0;
}

void playscale(int8_t n) {
	int8_t i;
	setf(0);
	delaycentiseconds(10);
	for(i=0;i<n;i++) {
		setf(notes[i]);
		delaycentiseconds(20);
		setf(0);
		delaycentiseconds(1);
	}
	delaycentiseconds(10);
}


int8_t processwaitingfornote(uint16_t scale, uint16_t note) {
	int8_t j;
	j= getnote(note);
		if (j==targetnote) {
			lastnote=j;
			return 1;
		}
		else {
			setf(0);
			delaycentiseconds(15);
			return 0;
		}
}

int8_t processnoteplaying(uint16_t scale, uint16_t note) {
	int8_t j;
	j=getnote(note);
	if (j!=targetnote) {
		setf(0);
		delaycentiseconds(15);
		return 0;
	} else {	
		j=20;
		if (scale & _BV(6))
			j=1;
		if (scale & _BV(7))
			j=2;
		if (scale & _BV(8))
			j=3;
		if (scale & _BV(9))
			j=4;
		if (scale & _BV(10))
			j=5;
		if (scale & _BV(4))
			j=-1;
		if (scale & _BV(3))
			j=-2;
		if (scale & _BV(2))
			j=-3;
		if (scale & _BV(1))
			j=-4;
		if (scale & _BV(0))
			j=-5;
		if (scale & _BV(11))
			j=10;
			
		if (j==20) {
			setf(0);
			delaycentiseconds(15);
			return 0;
		}
		
		if (j==10) {
			setftone(notes[8],2);
			delaycentiseconds(15);
			return 0;
		}
		
		if (j>0)
			setf(notes[6]);
		else
			setf(notes[7]);
		delaycentiseconds(onperiod[ABS(j)-1]);
		setf(0);
		delaycentiseconds(offperiod[ABS(j)-1]);
		return 0;
	}
	return 0;
}

void dosleep(void) {
	PORTB=0;
	DDRB=0;
	TCCR1A=0;
	TCCR1B=0;
	 set_sleep_mode(SLEEP_MODE_PWR_DOWN);
     sleep_mode();

}

int main (void)
{

	uint16_t scale,note;
	ioinit();
	int8_t state=0;
	int8_t waitingforkey=1;
	int8_t i;
	int8_t zerocounts=0;

	
	for(i=0;i<6;i++) {
		setf(notes[i]);
		delaycentiseconds(20);
		setf(0);
		delaycentiseconds(1);
	}
	for(i=1;i<6;i++) {
		setf(notes[5-i]);
		delaycentiseconds(20);
		setf(0);
		delaycentiseconds(1);
	}
	delaycentiseconds(15);

	/**
	 *while(1) {
	 *	for(i=0; i<9;i++){
	 *		setf(notes[i]);
	 *		delaydecseconds(100);
	 *	}
	 *}
	 */

	

	while(1) {
		if (waitingforkey) {
			if ((PINB & _BV(PB3))==0) {
				targetnote=targetnote+1;
				if (targetnote>6)
					targetnote=1;
				playscale(targetnote);
				waitingforkey=0;
				state=0;
			}
		} else {
			if (PINB & _BV(3))
				waitingforkey=1;
		}
		getscale(&scale, &note);
		if (scale==0 && note==0)
			zerocounts+=1;
		else
			zerocounts=0;
		if (zerocounts>100)
			dosleep();
		switch (state) {
			case 0:
				state=processnoteplaying(scale, note);
				
		}

	}




    return (0);
}
