// draw.c
// output routines
//

#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <avr/signal.h>
#include <avr/delay.h>
#include <avr/sleep.h>
#include <avr/pgmspace.h>
#include <string.h>
#include <math.h>

#include "hatdefs.h"
#include "fontnomirror.h"
#include "draw.h"
#include "utils.h"


void setupdisplays(BYTE front, BYTE back)
{
	out1bitck0=_BV(OE0)|_BV(OE1);
	out0bitck0=_BV(OE0)|_BV(OE1);
	outbitck1=_BV(OE0)|_BV(OE1);
	outframeck1=0;
	if (front)
	{
		out1bitck0|=_BV(DATA0);
		outbitck1|=_BV(CK_SH0);
		outframeck1|=_BV(CK_BUF0);
	}
	else
		outframeck1|=_BV(OE0);
	if(back)
	{
		out1bitck0|=_BV(DATA1);
		outbitck1|=_BV(CK_SH1);
		outframeck1|=_BV(CK_BUF1);
	}
	else
		outframeck1|=_BV(OE1);
}


// --------------------------------------------------
// Interrupt routine for display
// --------------------------------------------------

INTERRUPT(SIG_OUTPUT_COMPARE1A)
{

	uint8_t i;
	uint8_t outbit;
	uint8_t sample;

// Swap to new buffer at end of frame
	
	if (++count==NROWS)
	{
		count=0;
		framecount++;
		active_buf=next_buf;
		active_ptr=(pbyte_t) buf[active_buf];
	}
	
	
	sample=(BYTE)((BYTE)~*(active_ptr+2)) << (7-RBIT);
	for (i=0;i<(RBIT+1);i++)
	{
		outbit=((BYTE)(sample & 0x80)) ? out1bitck0 :out0bitck0;
		PORTSERIAL=outbit;
		sample = sample << 1;
		PORTSERIAL=(BYTE) outbitck1| outbit;
	}
	
	sample=(BYTE)~*(active_ptr+1); 
	for (i=0;i<8;i++)
	{
		outbit=((BYTE)(sample & 0x80)) ?out1bitck0 :out0bitck0;
		PORTSERIAL=outbit;
		sample = sample << 1;
		PORTSERIAL=(BYTE) outbitck1 | outbit;
	}
	
	sample=(BYTE)~*(active_ptr) ;
	for (i=0;i<8;i++)
	{
		outbit=((BYTE)(sample & 0x80)) ?out1bitck0 :out0bitck0;
		PORTSERIAL=outbit;
		sample = sample << 1;
		PORTSERIAL=(BYTE) outbitck1 | outbit;
	}
	
	active_ptr += LEAP;
	
	sample=(NROWS-1)-count;
	for (i=0;i<NROWS;i++)
	{
		outbit=(i==sample) ? out1bitck0 :out0bitck0;
		PORTSERIAL=outbit;
		PORTSERIAL=(BYTE) outbitck1 | outbit;
	}
	
	PORTSERIAL=outframeck1;
	
}

int badchar(BYTE c)
{
	char pic[NROWS+2];
	PGM_P p;
	
	if (c==32)
		return 0;
	memcpy_P(&p, &font[c-(BYTE)32], sizeof(PGM_P));
	memcpy_P(&pic,p,NROWS+2);
	
	return ((pic[1]!=7)||((pic[2]==0)&&(pic[3]==0)&&(pic[4]==0)&&(pic[5]==0)&&(pic[6]==0)&&(pic[7]==0)&&(pic[8]==0)));
}


void clearbuf(void)
{
	BYTE i;
	for(i=0;i<NROWS;i++)
	{
		*(plong_t) buf[write_buf][i]=0;
	}
}

void clearnextbuf(void)
{
	BYTE i;
	for(i=0;i<NROWS;i++)
	{
		*(plong_t) buf[next_buf][i]=0;
	}
}


void scrollleft(void)
{
	BYTE i;
	for(i=0;i<NROWS;i++)
	{
		*(plong_t) buf[write_buf][i]=(*(plong_t) buf[write_buf][i])<<1;
	}
}

int print(BYTE c,int8_t x, int8_t y)
{
	char pic[NROWS+2];
	int8_t j;
	PGM_P p;
	
	memcpy_P(&p, &font[c-(BYTE)32], sizeof(PGM_P));
	memcpy_P(&pic,p,NROWS+2);
	if ((x>-pic[0])&&(x<(NCOLS+pic[0])))
	{
		y+=pic[1]-1;
	
		x=NCOLS-x-pic[0];
		if (x>0)
		{
			for(j=0;j<pic[1];j++)
			{
				*(plong_t) buf[write_buf][y-j]|=((LONG) pic[j+2])<<x;
			}
		}
		else
		{
			x=-x;
			for(j=0;j<pic[1];j++)
			{
				*(plong_t) buf[write_buf][y-j]|=((LONG) pic[j+2])>>x;
			}
		}
	}
	return pic[0];
}

int printstring(int8_t x, int8_t y,BYTE underline)
{
	int i;
	int xincr;
	
	i=0;
	xincr=0;
	
	while (display_string[0][i]!=0)
	{
		xincr+=print(display_string[0][i],x+xincr,y);
		i++;
		xincr++;
	}
	
	if (underline)
		drawhline(x,x+xincr-1,y-2);
	return xincr;
}

BYTE rchar(BYTE c)
// Currently only works for characters 7 pixels high (doesn't check for this)
{
	char pic[NROWS+2];
	BYTE i;
	BYTE bitmask;
	PGM_P p;
	memcpy_P(&p, &font[c-(BYTE)32], sizeof(PGM_P));
	memcpy_P(&pic,p,NROWS+2);
	if (char_col==0)
	{
		char_col=pic[0];
		return char_col;
	}
	else
	{
		bitmask=1<<(--char_col);
		for(i=0;i<7;i++)
		{
			if(pic[i+2] & bitmask)
				buf[write_buf][6-i][0]|=1 ;
			else
				buf[write_buf][6-i][0]&=0xfe ;
		}
		return char_col;
	}
}



	
void copybuf(void)
{
	memcpy((void *)buf[write_buf],(void *)buf[next_buf],LEAP*NROWS);
}

void displayanaloglevel(void)
{
	LONG mask;
	mask=(1 << (analoglevel) )-1;
	*(plong_t) buf[write_buf][NROWS-1]=mask;
	*(plong_t) buf[write_buf][NROWS-2]=mask;
	*(plong_t) buf[write_buf][NROWS-3]=mask;
}

void plot(int8_t x, int8_t y)
{
	x=RETURNLIMIT(x,0,NCOLS-1);
	y=RETURNLIMIT(y,0,NROWS-1);
	*(plong_t) buf[write_buf][y] |= ((LONG)1 << (NCOLS-x-1) );
}

void drawhline(int8_t x1, int8_t x2,int8_t y)
{
	x1=RETURNLIMIT(x1,0,NCOLS-1);
	x2=RETURNLIMIT(x2,0,NCOLS-1);
	y=RETURNLIMIT(y,0,NROWS-1);
	*(plong_t) buf[write_buf][y] |= ((LONG)1 << (NCOLS-x1) )-((LONG)1 << (NCOLS-1-x2) );
}

void drawvline(int8_t x,int8_t y1, int8_t y2)
{
	LONG mask;
	int8_t y;
	x=RETURNLIMIT(x,0,NCOLS-1);
	y1=RETURNLIMIT(y1,0,NROWS-1);
	y2=RETURNLIMIT(y2,0,NROWS-1);
	mask=((LONG)1 << (NCOLS-x-1) );
	for(y=y1;y<=y2;y++)
		*(plong_t) buf[write_buf][y] |= mask;
}

void drawrect(int8_t x1, int8_t y1, int8_t x2,int8_t y2)
{
	int8_t y;
	LONG mask;
	
	x1=RETURNLIMIT(x1,0,NCOLS-1);
	y1=RETURNLIMIT(y1,0,NROWS-1);
	x2=RETURNLIMIT(x2,0,NCOLS-1);
	y2=RETURNLIMIT(y2,0,NROWS-1);
	mask=((LONG)1 << (NCOLS-x1) )-((LONG)1 << (NCOLS-1-x2)) ;
	for(y=y1;y<=y2;y++)
		*(plong_t) buf[write_buf][y] |= mask;
}

void displayanalogsquare(void)
{
	int8_t x;
	x = analoglevel>>1;
	drawrect((NCOLS>>1)-x,(NROWS>>1)-1-x,(NCOLS>>1)+x,(NROWS>>1)+x);
}
