#include <avr/io.h>
#include "main.h"

.global USART_RX_vect 
USART_RX_vect:
	push r26
	lds r26, UDR0				; R26 = Serial in
	sei							; Now we have read the serial data we can reenable interrupts without being interrupted immediately
	push r28					; Push Y reg
	push r29
	in r28,_SFR_IO_ADDR(SREG) 	; Get status register
	push r28 					; and put it on the stack

	
	lds r28,bufptr				; R28 (Lo Y)=bufptr
	lds r29,buflen
	cpi r29,BUFSIZE
	breq serintend
	add r28,r29					; + buflen
	inc r29
	sts buflen,r29
	andi r28,BUFMASK
	ldi r29,hi8(serbuf)
	std Y+0,r26
	
	; End interrupt
serintend:
	pop r26
	out _SFR_IO_ADDR(SREG),r26
	pop r29
	pop r28
	pop r26
	reti
	

.global TIMER0_OVF_vect
TIMER0_OVF_vect:

	; Interrupt header
;	sbi _SFR_IO_ADDR(PORTB),_BV(PB0) ; Signal we have started the interrupt
	push r26
	in r26,_SFR_IO_ADDR(SREG) 	; Get status register
	push r26 					; and put it on the stack
	push r27
	push r28					; Push Y reg
	push r29
	
	ldi r28,lo8(accumulator)	; Set Y to point to accumulator
	ldi r29,hi8(accumulator)
	; Process main oscillator
	ldd r26,Y+0					; Add "increment" to "accumulator"
	ldd r27,Y+8					; using 24 bits and r26,27
	add r26,r27
	std Y+0,r26
	
	ldd r26,Y+1		
	ldd r27,Y+9
	adc r26,r27
	std Y+1,r26
	
	ldd r26,Y+2
	ldd r27,Y+10
	adc r26,r27
	std Y+2,r26
	
	ldi r27,hi8(wave)
	ld r26,X
	out _SFR_IO_ADDR(OCR0A),r26
	
	
	; Process second oscillator
	ldd r26,Y+4					; Add "increment[1]" to "accumulator[1]"
	ldd r27,Y+12				; using 24 bits and r26,27
	add r26,r27
	std Y+4,r26
	
	ldd r26,Y+5		
	ldd r27,Y+13
	adc r26,r27
	std Y+5,r26
	
	ldd r26,Y+6
	ldd r27,Y+14
	adc r26,r27
	std Y+6,r26
	brcs lfooverflow 			; Special handling if we go past end of LFO cycle
	
completelfo:
	ldi r27,hi8(wave+256)
	ld r26,X
	out  _SFR_IO_ADDR(OCR0B),r26
	
	
intend:
	; End interrupt
	pop r29
	pop r28
	pop r27
	pop r26
	out _SFR_IO_ADDR(SREG),r26
	pop r26
;	cbi _SFR_IO_ADDR(PORTB),_BV(PB0) ; Sigal we have ended the interrupt
	reti
	

lfooverflow:
	lds r27,lfooneshot
	tst r27
	breq completelfo			; Not in one-shot mode so continue as normal
	ldi r27,0					; In one-shot mode
	std Y+12,r27				; Set increment[1] to 0
	std Y+13,r27
	std Y+14,r27
	ldi r27,255					; Set high byte of accumulator[1] to 255
	std Y+6,r27
	rjmp intend